
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Flowpesa — Verify ID (Front)</title>
  <link rel="stylesheet" href="css/style.css"/>
</head>
<body class="idv-screen">
  <header class="top-bar">
    <div class="top">
      <button class="back-btn" onclick="history.back()" aria-label="Back">←</button>
      <h1 class="top-title">Verify your identity</h1>
      <span class="top-ghost" aria-hidden="true"></span>
    </div>
  </header>

  <main class="content">
    <h2 class="heading">Capture your document</h2>
    <p class="subheading">Position the <strong>front</strong> of your document inside the frame.</p>

    <div class="cam-card">
      <video id="idv-video" autoplay playsinline muted></video>
      <div class="cam-frame"></div>
      <div id="fallback" class="cam-fallback" hidden>No camera available. Pick a photo below.</div>
    </div>

    <div class="cam-controls">
      <label class="ghost-pill" title="Pick from device">
        <input id="file-front" type="file" accept="image/*" hidden>
        🖼️
      </label>
      <button class="shutter" id="snap-front" aria-label="Take photo"></button>
      <button class="ghost-pill" id="rotate" aria-label="Switch camera">⟳</button>
    </div>

    <button class="btn-primary" id="next-front" disabled>Continue</button>
  </main>

  <!-- off-screen canvas for capture -->
  <canvas id="capture-canvas" style="display:none"></canvas>
  <script src="js/idv.js"></script>
  <script>window.IDV.start('front');</script>
</body>
</html>
